// Classes/MyOAuthTokenStorage.4dm
Class MyOAuthTokenStorage Shared singleton

Function onTokenReceived($accessToken : Text; $refreshToken : Text; $expiresIn : Real; $idToken : Text) : Boolean
	// This is called by 4D.NetKit.OAuth2Authorization after it gets the tokens.
	// You would store these tokens and associate them with the user.
	// For example, save to database.
	TRACE:C157("Server-side handler received tokens.")
	// Example: Store in a global variable for immediate use, or save to DB.
	// $g_lastAccessToken := $accessToken
	// $g_lastRefreshToken := $refreshToken
	return True:C214
	End Function
	
Function onOAuthError($errorCode : Text; $errorDescription : Text) : Boolean
	TRACE:C157("Server-side handler error: "+$errorCode+" - "+$errorDescription)
	// Handle error, e.g., redirect user to an error page.
	return False:C215
	End Function
	
	End Class