// Class file: Class.OAuth2Authorization.4dm
// This is a shared singleton class to handle the OAuth2 redirect callback.

shared singleton Class constructor()
	// This constructor is called only once when the singleton is first created.
	// You can use it to initialize any shared properties if needed.
	// For this handler, no specific initialization is required.
	
	// Create a new instance of the OAuth2Provider class that we can use later.
	This:C1470.provider:=cs:C1710.NetKit.OAuth2Provider.new()
	This:C1470.auth_code:=""
	
Function getResponse($request : 4D:C1709.IncomingMessage) : 4D:C1709.OutgoingMessage
	// This function acts as the HTTP handler defined in HTTPHandlers.json.
	// It receives the redirect request from Notion with the authorization code.
	
	var $response:=4D:C1709.OutgoingMessage.new()
	var $body_text : Text
	var $code : Text
	var $state : Text
	var $html_content : Text
	
	// Check if the request contains the authorization code.
	If (OB Is empty:C1297($request.urlQuery))
		$code:=$request.urlQuery.code
		$state:=$request.urlQuery.state
	End if 
	
	// Store the authorization code in a shared property.
	// This makes it accessible from other parts of your application.
	This:C1470.auth_code:=$code
	
	// Log the received code and state for debugging.
	LOG EVENT:C667("OAuth2 Redirect received. Code: "+$code+", State: "+$state)
	
	// Prepare an HTML response to send back to the user's browser.
	// This confirms that the callback was received successfully.
	$html_content:="<!DOCTYPE html>"+Char:C90(13)+\
		"<html lang=\"en\">"+Char:C90(13)+\
		"<head>"+Char:C90(13)+\
		"<meta charset=\"UTF-8\">"+Char:C90(13)+\
		"<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">"+Char:C90(13)+\
		"<title>Authorization Successful</title>"+Char:C90(13)+\
		"<style>"+Char:C90(13)+\
		"  body { font-family: sans-serif; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; background-color: #f0f4f8; }"+Char:C90(13)+\
		"  .container { text-align: center; padding: 40px; background-color: white; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }"+Char:C90(13)+\
		"  h1 { color: #2d3748; }"+Char:C90(13)+\
		"  p { color: #4a5568; }"+Char:C90(13)+\
		"</style>"+Char:C90(13)+\
		"</head>"+Char:C90(13)+\
		"<body>"+Char:C90(13)+\
		"<div class=\"container\">"+Char:C90(13)+\
		"  <h1>Authorization Successful!</h1>"+Char:C90(13)+\
		"  <p>You can now close this window and return to your application.</p>"+Char:C90(13)+\
		"</div>"+Char:C90(13)+\
		"</body>"+Char:C90(13)+\
		"</html>"
	
	$response.setBody($html_content)
	$response.setHeader("Content-Type"; "text/html")
	
	return $response
	
	
Function getAuthCode() : Text
	// A public shared function to retrieve the authorization code after the handler has been called.
	// This is where another part of your application would get the code to call getToken().
	
	// Since this is a shared singleton, the property 'auth_code' is persistent.
	return This:C1470.auth_code
	