//%attributes = {}
C_OBJECT:C1216($oauth2; $credential; $token)
C_TEXT:C284($authorizationCode)

// --- Existing Code (replace with your actual initialization) ---
// Example: Initialize OAuth2Provider (replace with your actual Client ID and Secret)
// Assuming $$client_id and $$client_secret are defined globally or you define them here
// If they are local, uncomment and define them:
// C_TEXT($$client_id; $$client_secret)
// $$client_id:="YOUR_NOTION_CLIENT_ID" // Replace with your Notion Client ID
// $$client_secret:="YOUR_NOTION_CLIENT_SECRET" // Replace with your Notion Client Secret

$oauth2:=cs:C1710.NetKit.OAuth2Provider.new()
$credential:=New object:C1471("redirectURI"; "http://localhost:50993/authorize")  // Your redirect URI

// This part would typically get the authorizationCode from the HTTP Callback.
// For testing this specific snippet, ensure $authorizationCode is populated.
// In your full method, $authorizationCode would come from the callback URL.
// Example for testing this snippet in isolation:
// $authorizationCode:="YOUR_AUTHORIZATION_CODE_FROM_CALLBACK"

// --- End Existing Code ---

ALERT:C41("Attempting to get Notion access token...")  // Add this line

// --- START: Manual HTTP Request for Token Exchange (REPLACES cs.NetKit.OAuth2Provider.getToken) ---

C_TEXT:C284($tokenEndpointURL; $requestBody; $base64Auth; $authHeaderValue)
C_OBJECT:C1216($httpRequest; $httpResponse; $responseHeadersObject)
C_TEXT:C284($responseBodyText; $responseHeadersText)

// 1. Define the Token Endpoint URL
$tokenEndpointURL:="https://api.notion.com/v1/oauth/token"

// 2. Prepare the Request Body (JSON)
$requestBody:="{"+\
"\"grant_type\": \"authorization_code\","+\
"\"code\": \""+$authorizationCode+"\","+\
"\"redirect_uri\": \""+$credential.redirectURI+"\""+\
"}"

// 3. Prepare the Authorization Header (Base64 Basic Auth)
// This combines your Client ID and Client Secret
// Make sure $$client_id and $$client_secret contain your actual values.
$base64Auth:=BToT(Base64Encode(To blob($$client_id+":"+$$client_secret; UTF8)), UTF8)
$authHeaderValue:="Basic "+$base64Auth

// 4. Create an HTTP Request Object
$httpRequest:=HTTP Request:C1158.new()

// 5. Set Request Properties
$httpRequest.method:="POST"
$httpRequest.url:=$tokenEndpointURL
$httpRequest.headers.add("Content-Type"; "application/json")
$httpRequest.headers.add("Authorization"; $authHeaderValue)
$httpRequest.body:=$requestBody

// --- DEBUGGING: ALERT the Request details before sending ---
ALERT:C41("Sending HTTP POST Request to Notion Token Endpoint:"+Char:C90(13)+Char:C90(10)+\
"URL: "+$httpRequest.url+Char:C90(13)+Char:C90(10)+\
"Headers (partial):"+Char:C90(13)+Char:C90(10)+\
"  Content-Type: "+$httpRequest.headers.get("Content-Type")+Char:C90(13)+Char:C90(10)+\
"  Authorization: "+$httpRequest.headers.get("Authorization")+Char:C90(13)+Char:C90(10)+\
"Body: "+$httpRequest.body)

// 6. Send the Request and get the Response
$httpResponse:=$httpRequest.send()

// 7. Extract and ALERT the Response details
$responseBodyText:=$httpResponse.body.text
$responseHeadersObject:=$httpResponse.headers  // Get the headers object
$responseHeadersText:=$responseHeadersObject.toJSON()  // Convert headers object to JSON string for display

ALERT:C41("Received HTTP Response from Notion Token Endpoint:"+Char:C90(13)+Char:C90(10)+\
"Status: "+String:C10($httpResponse.status)+" "+$httpResponse.statusText+Char:C90(13)+Char:C90(10)+\
"Response Headers: "+Char:C90(13)+Char:C90(10)+\
$responseHeadersText+Char:C90(13)+Char:C90(10)+\
"Response Body:"+Char:C90(13)+Char:C90(10)+\
$responseBodyText)

// --- END: Manual HTTP Request for Token Exchange ---

// --- Original Logic (or simplified for this test) ---
// After the manual request, $httpResponse contains the raw response.
// You would then process $httpResponse.status, $responseHeadersText, and $responseBodyText
// to understand Notion's response.

// Since we are bypassing NetKit's getToken() for this test,
// we don't directly get a $token object in the same way.
// You would manually check $httpResponse.status.
If ($httpResponse.status=200)
	ALERT:C41("HTTP Request was successful. Check the ALERT with Response Body and Headers for content.")
	// In a real scenario, you'd parse $responseBodyText as JSON here
	// $notionTokenData:=JSON Parse($responseBodyText)
	// If ($notionTokenData.access_token # "")
	//     ALERT("Notion Access Token: " + $notionTokenData.access_token)
	// End If
Else 
	ALERT:C41("HTTP Request failed with status: "+String:C10($httpResponse.status)+" "+$httpResponse.statusText)
End if 