//%attributes = {}
TRACE:C157
#DECLARE($token : Text)
var $headers : Object
var $request : 4D:C1709.HTTPRequest
var $pageId : Text
var $response : Object
var $blocks : Collection
var $i : Integer
var $j : Integer

// Keep the page ID
$pageId:="2454fd2a-c9c5-805a-8e75-e52a02b08e31"  // This is the ID of your Notion page

$headers:=New object:C1471
$headers.Accept:="application/json"
$headers["Content-Type"]:="application/json"
$headers.Authorization:="Bearer "+"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"
$headers["Notion-Version"]:="2022-06-28"

// Get all blocks from the page to find the child_database block
$request:=4D:C1709.HTTPRequest.new("https://api.notion.com/v1/blocks/"+$pageId+"/children"; {method: "GET"; headers: $headers})
$request.wait(30)

var $debugText : Text
$debugText:="DEBUG INFO:\n\n"
$debugText:=$debugText+"Initial Request Status (Page Children): "+String:C10($request.response.status)+"\n"
$debugText:=$debugText+"Status Text: "+String:C10($request.response.statusText)+"\n\n"

If (($request.response.status>=200) & ($request.response.status<300))
	// Parse the response
	Case of 
		: (Value type:C1509($request.response.body)=Is text:K8:3)
			$response:=JSON Parse:C1218($request.response.body)
		: (Value type:C1509($request.response.body)=Is object:K8:27)
			$response:=$request.response.body
		Else 
			$response:=JSON Parse:C1218(String:C10($request.response.body))
	End case 
	
	If ($response.results#Null:C1517)
		$blocks:=$response.results
		$debugText:=$debugText+"Total blocks found on page: "+String:C10($blocks.length)+"\n\n"
		
		// Show all block types first
		$debugText:=$debugText+"Block types found on page:\n"
		For ($i; 0; $blocks.length-1)
			var $block : Object
			$block:=$blocks[$i]
			$debugText:=$debugText+"- Block "+String:C10($i)+": "+String:C10($block.type)
			If ($block.has_children=True:C214)
				$debugText:=$debugText+" (has children)"
			End if 
			$debugText:=$debugText+"\n"
		End for 
		$debugText:=$debugText+"\n"
		
		var $databaseFound : Boolean
		$databaseFound:=False:C215
		var $databaseId : Text
		var $inventoryText : Text
		$inventoryText:=""
		
		// Look for a 'child_database' block
		For ($i; 0; $blocks.length-1)
			var $block : Object
			$block:=$blocks[$i]
			
			If ($block.type="child_database")
				$databaseFound:=True:C214
				$databaseId:=$block.id  // Get the ID of the child database
				$debugText:=$debugText+"CHILD DATABASE FOUND at block "+String:C10($i)+" with ID: "+String:C10($databaseId)+"!\n"
				break  // Assuming only one database is relevant for inventory
			End if 
		End for 
		
		If ($databaseFound)
			// Now, query the database itself to get its content (rows)
			var $dbRequest : 4D:C1709.HTTPRequest
			var $dbResponse : Object
			
			$dbRequest:=4D:C1709.HTTPRequest.new("https://api.notion.com/v1/databases/"+$databaseId+"/query"; {method: "POST"; headers: $headers})
			$dbRequest.wait(30)
			
			$debugText:=$debugText+"Database Query Status: "+String:C10($dbRequest.response.status)+"\n"
			$debugText:=$debugText+"Database Query Status Text: "+String:C10($dbRequest.response.statusText)+"\n\n"
			
			If (($dbRequest.response.status>=200) & ($dbRequest.response.status<300))
				Case of 
					: (Value type:C1509($dbRequest.response.body)=Is text:K8:3)
						$dbResponse:=JSON Parse:C1218($dbRequest.response.body)
					: (Value type:C1509($dbRequest.response.body)=Is object:K8:27)
						$dbResponse:=$dbRequest.response.body
					Else 
						$dbResponse:=JSON Parse:C1218(String:C10($dbRequest.response.body))
				End case 
				
				var $dbPages : Collection
				$dbPages:=$dbResponse.results
				TRACE:C157
				$debugText:=$debugText+"Database entries (pages) found: "+String:C10($dbPages.length)+"\n\n"
				
				$inventoryText:=$inventoryText+"INVENTORY DATABASE CONTENT:\n\n"
				
				// Show just the properties values in JSON format
				$inventoryText:=$inventoryText+"DATABASE PROPERTIES VALUES:\n\n"
				
				For ($j; 0; $dbPages.length-1)
					var $page : Object
					$page:=$dbPages[$j]
					$inventoryText:=$inventoryText+"Row "+String:C10($j+1)+" properties:\n"
					$inventoryText:=$inventoryText+JSON Stringify:C1217($page.properties; *)+"\n\n"
				End for 
				
			Else 
				$debugText:=$debugText+"Error querying database: "+String:C10($dbRequest.response.status)+" - "+String:C10($dbRequest.response.statusText)+"\n"
			End if 
			
		Else 
			$debugText:=$debugText+"No 'child_database' block found on this page.\n"
		End if 
		
		// Show debug info first
		ALERT:C41($debugText)
		
		// Then show inventory if found
		If ($inventoryText#"")
			ALERT:C41($inventoryText)
		End if 
		
	Else 
		ALERT:C41("No results found in page children response")
	End if 
	
Else 
	ALERT:C41("Error retrieving page blocks: "+String:C10($request.response.status)+" - "+String:C10($request.response.statusText))
End if 

TRACE:C157