//%attributes = {}
// Manual Notion OAuth2 Implementation - Simple Test

var $clientId : Text:="231d872b-594c-80bc-9ad0-00377e36aaf4"
var $redirectURI : Text:="http://localhost/authorize"  // Exactly as in Notion
var $state : Text:=String:C10(Random:C100)+"_"+String:C10(Milliseconds:C459)

// Build the authorization URL with exact encoding
var $authURL : Text:="https://api.notion.com/v1/oauth/authorize"
$authURL+="?client_id="+$clientId
$authURL+="&redirect_uri=http%3A//localhost/authorize"  // URL encoded version
$authURL+="&response_type=code"
$authURL+="&state="+$state

ALERT:C41("Testing with exact Notion settings: "+$redirectURI)
ALERT:C41("Full URL: "+$authURL)

OPEN URL:C673($authURL)

ALERT:C41("Check if it worked. Even if you see an error page, look at the URL bar for 'code=' parameter")

// Step 2: Get the authorization code from user
var $code : Text:=Request:C163("After authorizing, you'll be redirected to a page that might show an error."+\
"\nLook at the URL in your browser - it should contain 'code=XXXXXX'"+\
"\nCopy and paste the code value here:"; "")

If ($code="")
	ALERT:C41("No code provided. OAuth cancelled.")
Else 
	// Step 3: Exchange code for access token
	var $tokenRequest : Object
	var $tokenResponse : Object
	var $token : Object
	
	// Prepare token exchange request
	$tokenRequest:=New object:C1471
	$tokenRequest.url:="https://api.notion.com/v1/oauth/token"
	$tokenRequest.method:="POST"
	$tokenRequest.headers:=New object:C1471(\
		"Content-Type"; "application/json"; \
		"Authorization"; "Basic "+BASE64 ENCODE:C895($clientId+":"+$clientSecret))
	
	$tokenRequest.body:=JSON Stringify:C1217(New object:C1471(\
		"grant_type"; "authorization_code"; \
		"code"; $code; \
		"redirect_uri"; $redirectURI))
	
	// Make the token request
	var $status : Integer
	var $responseText : Text
	
	$status:=HTTP Request:C1158(HTTP POST method:K71:2; $tokenRequest.url; $tokenRequest.body; $responseText; $tokenRequest.headers)
	
	If ($status=200)
		$token:=JSON Parse:C1218($responseText)
		ALERT:C41("Success! Access token: "+$token.access_token)
		
		// Test the token by calling Notion API
		var $testHeaders : Object:=New object:C1471(\
			"Authorization"; "Bearer "+$token.access_token; \
			"Notion-Version"; "2022-06-28")
		var $testResponseText : Text
		var $testStatus : Integer
		
		$testStatus:=HTTP Request:C1158(HTTP GET method:K71:1; "https://api.notion.com/v1/users/me"; ""; $testResponseText; $testHeaders)
		
		If ($testStatus=200)
			var $user : Object:=JSON Parse:C1218($testResponseText)
			ALERT:C41("Token works! User: "+$user.name)
		Else 
			ALERT:C41("Token received but API test failed. Status: "+String:C10($testStatus))
		End if 
		
	Else 
		ALERT:C41("Token exchange failed. Status: "+String:C10($status)+"\nResponse: "+$responseText)
	End if 
End if 