# Project Title

Integrating 4D with Notion: Creating Pages and Databases Using the Notion API 
## Description

This technical note explores the integration of 4D, a powerful application development environment, with Notion, a modern workspace platform, using the Notion API. The guide demonstrates how to perform CRUD (Create, Read, Update, Delete) operations in Notion databases and pages programmatically from within a 4D application. By leveraging 4D's HTTP request capabilities and parsing tools, developers can seamlessly push structured business data—such as inventory —into Notion for tracking, collaboration, or analytics purposes. A sample business application will showcase real-world use, highlighting how completed transactions in 4D can automatically generate structured entries in Notion, transforming how teams visualize and manage operational data.

## Getting Started

### Dependencies

*4D 20R9
*A Notion integration created with Internal Integration Secret credentials
*Familiarity with JSON and REST APIs

### Installing

* Obtain the internal integration secret. Please read more in section "Obtaining the authentication key"
* Clone the template indicated in the document and obtain the database ID. 

### Executing program

* Open the project in 4D 
* In the dialogs, introduce the Internal Integration Secret and the database ID.

## Qodly

This tech note has a Qodly page presenting the notion data. To access this notion page, follow these steps:

* Run > Start Web Server
* Design > Preview Qodly Application..


## Authors

Al Mahdi Bakkali
[@almahdi.bakkali@4D.com](almahdi.bakkali@4D.com)

